%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      GetSensorParameters.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          Psych 221
% Description:    Get parameters from the sensor, scene and optics
%                 structures
%--------------------------------------------------------------------------

% Parameters that we are interested in:

% From pixel structure
%------------------------
% Pixel width (um)
% Pixel height (um)
% Fill factor
% Dark Voltage (V)
% Read Noise (mV)
% Conversion Gain (uV/e)
% Voltage Swing (V)
% Well Capacity (electrons)

% From sensor structure
%------------------------
% Dark Signal nununifomity (DSNU) (mV)
% PhotoReceptor nonuniformity (PRNU)(%)
% Analog gain

% From scene structure
%------------------------
% Mean Scene luminance (cd/m^2)
% Distance from lens to object (m)

% From optics structure
%------------------------
% Lens f-number

% From oi structure
%------------------------
% Image width (mm)
% Image height (mm)

% First get the pixel structure from the sensor we use:
pixel =  sensorGet(sensor,'pixel');

SensorParameters = struct;

SensorParameters.pixelwidth = pixelGet(pixel,'pixelwidth','um');        % Pixel width (um)
SensorParameters.pixelheight = pixelGet(pixel,'pixelheight','um');      % Pixel height (um)
SensorParameters.fillfactor = pixelGet(pixel,'fillfactor');             % Fill factor
SensorParameters.darkvoltage = pixelGet(pixel,'darkvoltage');           % Dark Voltage (V)
SensorParameters.readnoise = pixelGet(pixel,'readnoisemillivolts');     % Read Noise (mV)
SensorParameters.conversiongain = pixelGet(pixel,'conversiongain')*(10^6);     % Conversion Gain (uV/e)
SensorParameters.voltageswing = pixelGet(pixel,'voltageswing');         % Voltage Swing (V)
SensorParameters.wellcapacity = pixelGet(pixel,'wellcapacity');         % Well Capacity (electrons)

SensorParameters.dsnu = sensorGet(sensor,'dsnusigma');                  % Dark Signal nununifomity (DSNU) (mV)
SensorParameters.prnu = sensorGet(sensor,'prnusigma');                  % PhotoReceptor nonuniformity (PRNU)(%)
SensorParameters.analogGain = sensorGet(sensor,'analogGain');           % Analog gain

SensorParameters.meanluminance = sceneGet(scene,'meanluminance');       % Mean Scene luminance (cd/m^2)
SensorParameters.ObjectDistance = sceneGet(scene,'objectdistance');     % Distance from lens to object (m)


SensorParameters.fnumber = opticsGet(optics,'fnumber');                 % Lens f-number


SensorParameters.oiWidth = oiGet(oi,'width','um');                      % Image width (um)
SensorParameters.oiHeight = oiGet(oi,'height','um');                    % Image height (um)
% SensorParameters.ImageDist = oiGet(oi,'imagedistance');               % Image distance (m)

% Save the sensor parameters
save('SensorParameters.mat','SensorParameters');

% Display the sensor parameters
SensorParameters













